unit CVSTrac2TracConvertUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs,SQLiteTable3, inifiles, StdCtrls, md5;

const
     cvstracdbname = 'devel.db';
type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}
const DefaultTimeZone = 'GMT -7:00';
      PriorityStrCount = 4;
      prioritystr : array[1..PriorityStrCount] of string = (
      'Critical',
      'High',
      'Low',
      'Trivial'
       );
      SeverityStrCount = 3;
      Severitystr : array[1..SeverityStrCount] of string = (
      'Easy',
      'Average',
      'Hard'
       );

procedure TForm1.Button1Click(Sender: TObject);
var
    CVSTRACdbpointerpath: string;
    CVSTRACdbpointer: TSQLiteDatabase;
    CVSTRACtablepointerenums: TSQLIteTable;
    CVSTRACtablepointeruser: TSQLIteTable;
    CVSTRACtablepointerticket: TSQLIteTable;
    CVSTRACtablepointertktchng: TSQLIteTable;
    CVSTRACtablepointerchng: TSQLIteTable;
    CVSTRACtablepointerxref: TSQLIteTable;
    CVSTRACtablepointerconfig: TSQLIteTable;
    CVSTRACtablepointerwiki: TSQLIteTable;
    TRACdbpointerpath: string;
    TRACdbpointer: TSQLiteDatabase;
    TRACtablepointerWiki : TSQLiteTable;
    usr,tktcust : textfile;
    sSQL, stype, tn, status, resolution, ver, dt,
    milestone, msg, branch, ms, prio, sevr, user, earlydate, oldtxt,newtxt,fldid: String;
    version,milestones : Tstringlist;
    MilestoneIDX, MessageIDX, TicketNumIDX, UserIDX, TypeIDX, TitleIDX,
    NewTextIdx, OLDTextIDX, DateIDX,
    StatusIDX,VersionIDX,PriorityIDX,SeverityIDX,
    ChangeTimeIDX, SubsystemIDX, OwnerIDX, ContactIDX, DescriptionIDX,
    i,p,s,e : integer;
    extrastr : array[1..5] of record
      S : string;  //names for the extra1..5 fields in the cvsdb
      I : integer; //index of extra1..5 field in ticket
      end;

  function cleanstr(x:string):string;
    var i : integer;
    begin
    i := 1;
    while i <= length(x) do
      if copy(x,i,1) < #32 then
        Delete(x,i,1)
      else
        inc(i);
    cleanstr := x;
    end;
  function fixdblq(x:string):string;
    var i : integer;
    begin
    i := 1;
    while i <= length(x) do
      if copy(x,i,1) ='"' then
        begin
        insert('"',x,i); // x := copy(x,1,i-1)+''''+copy(x,i+1,length(x)); inc(1);
        inc(i,2)
        end
      else
        inc(i);
    fixdblq := x;
    end;
  procedure addpermission(user,perm : string);
    begin
    sSQL := 'INSERT INTO permission(username,action) VALUES ("'+user+'","'+perm+'");';
   //do the insert
    TracdbPointer.BeginTransaction;
    TracdbPointer.ExecSQL(sSQL);
    TracdbPointer.Commit;
    end;


  procedure adduser(username,capabilities : string);
  var i : integer;
{ a,d,i,j,k,n,o,p,q,r,s,w
a  Admin: Create or delete users and ticket report formats   TRAC_ADMIN
d  Delete: Erase anonymous wiki, tickets, and attachments    TICKET_MODITY
i  Check-in: Add new code to the repository
j  Read-Wiki: View wiki pages                                WIKI_VIEW
k  Wiki: Create or modify wiki pages                         WIKI_CREATE,WIKI_MODIFY
n  New: Create new tickets                                   TICKET_CREATE
o  Check-out: Read code out of the repository                FILE_VIEW
p  Password: Change password
q  Query: Create or edit report formats                      REPORT_ADMIN
r  Read: View tickets and change histories                   TICKET_VIEW,REPORT_VIEW
s  Setup: Change CVSTrac options                             TRAC_ADMIN
w  Write: Edit tickets                                       TICKET_MODIFY

TICKET_ADMIN = TICKET_MODIFY(TICKET_CHGPROP,TICKET_APPEND) +TICKET_CREATE+TICKET_VIEW

INSERT INTO "permission" VALUES('anonymous','LOG_VIEW');
INSERT INTO "permission" VALUES('anonymous','FILE_VIEW');
INSERT INTO "permission" VALUES('anonymous','WIKI_VIEW');
INSERT INTO "permission" VALUES('anonymous','WIKI_CREATE');
INSERT INTO "permission" VALUES('anonymous','WIKI_MODIFY');
INSERT INTO "permission" VALUES('anonymous','SEARCH_VIEW');
INSERT INTO "permission" VALUES('anonymous','REPORT_VIEW');
INSERT INTO "permission" VALUES('anonymous','REPORT_SQL_VIEW');
INSERT INTO "permission" VALUES('anonymous','TICKET_VIEW');
INSERT INTO "permission" VALUES('anonymous','TICKET_CREATE');
INSERT INTO "permission" VALUES('anonymous','TICKET_MODIFY');
INSERT INTO "permission" VALUES('anonymous','BROWSER_VIEW');
INSERT INTO "permission" VALUES('anonymous','TIMELINE_VIEW');
INSERT INTO "permission" VALUES('anonymous','CHANGESET_VIEW');
INSERT INTO "permission" VALUES('anonymous','ROADMAP_VIEW');
INSERT INTO "permission" VALUES('anonymous','MILESTONE_VIEW');
INSERT INTO "permission" VALUES('anonymous','TRAC_ADMIN');
}
    procedure kill(var s : string; x : String);
      var k : integer;
      begin
      k := pos(x,s);
      if k > 0 then
        s := copy(s,1,k-1)+' '+copy(S,k+1,length(s));
      end;
    begin
    for i := 1 to length(capabilities) do
      begin
      if (Capabilities[i] in ['a','s']) then
        begin
        Kill(Capabilities,'a');
        Kill(Capabilities,'s');
        addpermission(username,'TRAC_ADMIN')
        end
      else
      if (Capabilities[i] in ['d','w']) then
        begin
        Kill(Capabilities,'d');
        Kill(Capabilities,'w');
        addpermission(username,'TICKET_MODIFY')
        end
      else
      if copy(Capabilities,i,1) = 'j' then
        addpermission(username,'WIKI_VIEW')
      else
      if copy(Capabilities,i,1) = 'k' then
        begin
        addpermission(username,'WIKI_CREATE');
        addpermission(username,'WIKI_MODIFY');
        end
      else
      if copy(Capabilities,i,1) = 'n' then
        addpermission(username,'TICKET_CREATE')
      else
      if copy(Capabilities,i,1) = 'o' then
        addpermission(username,'FILE_VIEW')
      else
      if copy(Capabilities,i,1) = 'q' then
        addpermission(username,'REPORT_ADMIN')
      else
      if copy(Capabilities,i,1) = 'r' then
        begin
        addpermission(username,'TICKET_VIEW');
        addpermission(username,'REPORT_VIEW');
        end
      end;
    end;
    {
'LOG_VIEW'
'SEARCH_VIEW'
'REPORT_SQL_VIEW'
'BROWSER_VIEW'
'TIMELINE_VIEW'
'CHANGESET_VIEW'
'ROADMAP_VIEW'
'MILESTONE_VIEW'
     }


begin
milestones := TStringList.Create;
CVSTRACdbpointerpath := ExtractFilepath(application.exename) + cvstracdbname;
CVSTRACdbpointer := TSQLiteDatabase.Create(CVSTRACdbpointerpath);
TRACdbpointerpath := ExtractFilepath(application.exename) + 'trac.db';
TRACdbpointer := TSQLiteDatabase.Create(TRACdbpointerpath);

try

  if not CVSTRACdbpointer.TableExists('config') then
    begin
    memo1.lines.add('config input table not found');
    end;
  if not CVSTRACdbpointer.TableExists('enums') then
    begin
    memo1.lines.add('enums input table not found');
    end;
  if not CVSTRACdbpointer.TableExists('user') then
    begin
    memo1.lines.add('user input table not found');
    end;
  if not CVSTRACdbpointer.TableExists('ticket') then
    begin
    memo1.lines.add('ticket input table not found');
    end;
  if not CVSTRACdbpointer.TableExists('tktchng') then
    begin
    memo1.lines.add('tktchng input table not found');
    end;
  if not CVSTRACdbpointer.TableExists('chng') then
    begin
    memo1.lines.add('chng input table not found');
    end;
  if not CVSTRACdbpointer.TableExists('xref') then
    begin
    memo1.lines.add('xref input table not found');
    end;
  if not CVSTRACdbpointer.TableExists('wiki') then
    begin
    memo1.lines.add('wiki input table not found');
    end;
  if not TRACdbpointer.TableExists('enum') then
    begin
    memo1.lines.add('enum output table not found');
    end;
  if not TRACdbpointer.TableExists('component') then
    begin
    memo1.lines.add('Component output table not found');
    end;
  if not TRACdbpointer.TableExists('ticket') then
    begin
    memo1.lines.add('Ticket output table not found');
    end;
  if not TRACdbpointer.TableExists('ticket_change') then
    begin
    memo1.lines.add('Ticket_change output table not found');
    end;
  if not TRACdbpointer.TableExists('ticket_custom') then
    begin
    memo1.lines.add('Ticket_custom output table not found');
    end;
  if not TRACdbpointer.TableExists('wiki') then
    begin
    memo1.lines.add('wiki output table not found');
    end;
  if not TRACdbpointer.TableExists('milestone') then
    begin
    memo1.lines.add('Milestone output table not found');
    end;

  try
    sSQL := 'DELETE FROM enum WHERE type = "ticket_type";';
    TracdbPointer.BeginTransaction;
    TracdbPointer.ExecSQL(sSQL);
    TracdbPointer.Commit;
    sSQL := 'DELETE FROM enum WHERE type = "priority";';
    TracdbPointer.BeginTransaction;
    TracdbPointer.ExecSQL(sSQL);
    TracdbPointer.Commit;
    sSQL := 'DELETE FROM enum WHERE type = "severity";';
    TracdbPointer.BeginTransaction;
    TracdbPointer.ExecSQL(sSQL);
    TracdbPointer.Commit;
    sSQL := 'DELETE FROM enum WHERE type = "status";';
    TracdbPointer.BeginTransaction;
    TracdbPointer.ExecSQL(sSQL);
    TracdbPointer.Commit;
    sSQL := 'DELETE FROM component;';
    TracdbPointer.BeginTransaction;
    TracdbPointer.ExecSQL(sSQL);
    TracdbPointer.Commit;
    sSQL := 'DELETE FROM ticket;';
    TracdbPointer.BeginTransaction;
    TracdbPointer.ExecSQL(sSQL);
    TracdbPointer.Commit;
    sSQL := 'DELETE FROM ticket_custom;';
    TracdbPointer.BeginTransaction;
    TracdbPointer.ExecSQL(sSQL);
    TracdbPointer.Commit;
    sSQL := 'DELETE FROM ticket_change;';
    TracdbPointer.BeginTransaction;
    TracdbPointer.ExecSQL(sSQL);
    TracdbPointer.Commit;
    sSQL := 'DELETE FROM version;';
    TracdbPointer.BeginTransaction;
    TracdbPointer.ExecSQL(sSQL);
    TracdbPointer.Commit;
    sSQL := 'DELETE FROM permission;';
    TracdbPointer.BeginTransaction;
    TracdbPointer.ExecSQL(sSQL);
    TracdbPointer.Commit;
    sSQL := 'DELETE FROM milestone;';
    TracdbPointer.BeginTransaction;
    TracdbPointer.ExecSQL(sSQL);
    TracdbPointer.Commit;
    sSQL := 'DELETE FROM revision;';
    TracdbPointer.BeginTransaction;
    TracdbPointer.ExecSQL(sSQL);
    TracdbPointer.Commit;
    sSQL := 'DELETE FROM node_change;';
    TracdbPointer.BeginTransaction;
    TracdbPointer.ExecSQL(sSQL);
    TracdbPointer.Commit;
    addpermission('anonymous','LOG_VIEW');
    addpermission('anonymous','FILE_VIEW');
    addpermission('anonymous','WIKI_VIEW');
    addpermission('anonymous','WIKI_CREATE');
    addpermission('anonymous','WIKI_MODIFY');
    addpermission('anonymous','SEARCH_VIEW');
    addpermission('anonymous','REPORT_VIEW');
    addpermission('anonymous','REPORT_SQL_VIEW');
    addpermission('anonymous','TICKET_VIEW');
    addpermission('anonymous','TICKET_CREATE');
    addpermission('anonymous','TICKET_MODIFY');
    addpermission('anonymous','BROWSER_VIEW');
    addpermission('anonymous','TIMELINE_VIEW');
    addpermission('anonymous','CHANGESET_VIEW');
    addpermission('anonymous','ROADMAP_VIEW');
    addpermission('anonymous','MILESTONE_VIEW');
//    addpermission('anonymous','TRAC_ADMIN');
    TracdbPointer.BeginTransaction;
    for i := 1 to PriorityStrCount do
      begin
      sSQL := 'INSERT INTO enum(type,name,value) VALUES ("priority","'+PriorityStr[i]+'","'+IntToStr(i)+'");';
      TracdbPointer.ExecSQL(sSQL);
      end;
    TracdbPointer.Commit;
    TracdbPointer.BeginTransaction;
    for i := 1 to SeverityStrCount do
      begin
      sSQL := 'INSERT INTO enum(type,name,value) VALUES ("severity","'+SeverityStr[i]+'","'+IntToStr(i)+'");';
      TracdbPointer.ExecSQL(sSQL);
      end;
    TracdbPointer.Commit;
    //query the data
    CVSTRACtablepointerconfig := CVSTRACdbpointer.GetTable('SELECT * FROM config;');
    i := 1;
    fillchar(extrastr,sizeof(extrastr),0);
    Memo1.Lines.add('Config: '+IntToStr(CVSTRACtablepointerConfig.Count));
    if CVSTRACtablepointerConfig.Count > 0 then
      begin
      while i <= CVSTRACtablepointerConfig.Count do
        begin
        oldtxt := CVSTRACtablepointerConfig.FieldAsString(CVSTRACtablepointerConfig.FieldIndex['name']);
        newtxt := CVSTRACtablepointerConfig.FieldAsString(CVSTRACtablepointerConfig.FieldIndex['value']);
        if (copy(oldtxt,1,5) = 'extra') and (copy(oldtxt,8,4) = 'name') then
          begin
          val(copy(oldtxt,6,1),p,e);
          if (e = 0) and (p > 0) and (p < 6) then
            extrastr[p].S := trim(fixdblq(newtxt));
          end;
        CVSTRACtablepointerconfig.next;
        inc(i);
        end;
      end;
    CVSTRACtablepointerConfig.free;

    assignfile(tktcust,'Trac.ini.custom');
    rewrite(tktcust);
    writeln(tktcust,'[ticket-custom]');
    for i := 1 to 5 do
      begin
      if extrastr[i].S <> '' then
        begin
        for p := 1 to length(extrastr[i].S) do
          if extrastr[i].S[p] = ' ' then extrastr[i].S[p] := '_';
        writeln(tktcust,extrastr[i].S,' = text');
        end;
      end;
    closefile(tktcust);
    //query the data
    CVSTRACtablepointeruser := CVSTRACdbpointer.GetTable('SELECT * FROM user;');
    i := 1;
    Memo1.Lines.add('Users: '+IntToStr(CVSTRACtablepointeruser.Count));
    if CVSTRACtablepointeruser.Count > 0 then
      begin
      assignfile(usr,'passwd');
      rewrite(usr);   {username:trac:a056fafaf587799d45f19dea506ef6fd}
      while i <= CVSTRACtablepointeruser.Count do
        begin
        user := CVSTRACtablepointeruser.FieldAsString(CVSTRACtablepointeruser.FieldIndex['id']);
        sSQL := 'DELETE FROM session_attribute WHERE sid = "'+user+'";';
        TracdbPointer.BeginTransaction;
        TracdbPointer.ExecSQL(sSQL);
        TracdbPointer.Commit;

        ssql := 'INSERT INTO session_attribute(sid,authenticated,name,value) VALUES("'+
          User+ '",1,"name","'+
          CVSTRACtablepointeruser.FieldAsString(CVSTRACtablepointeruser.FieldIndex['name'])
          +'")';
        TracdbPointer.BeginTransaction;
        TracdbPointer.ExecSQL(sSQL);
        ssql := 'INSERT INTO session_attribute(sid,authenticated,name,value) VALUES("'+
          User+ '",1,"email","'+
          CVSTRACtablepointeruser.FieldAsString(CVSTRACtablepointeruser.FieldIndex['email'])
          +'")';
        TracdbPointer.ExecSQL(sSQL);
        ssql := 'INSERT INTO session_attribute(sid,authenticated,name,value) VALUES("'+
          User+ '",1,"tz","'+DefaultTimeZone+'")';
        TracdbPointer.ExecSQL(sSQL);
        TracdbPointer.Commit;
        adduser(
          user,
          CVSTRACtablepointeruser.FieldAsString(CVSTRACtablepointeruser.FieldIndex['capabilities']) );
        write(usr,
          user,
          ':trac:',lowercase(MD5DigestToStr(MD5String(user+':trac:'+user))),#10);
        CVSTRACtablepointeruser.next;
        inc(i);
        end;
      closefile(usr);
      end;
    //query the data
    CVSTRACtablepointerenums := CVSTRACdbpointer.GetTable('SELECT * FROM enums;');
    i := 1;
    Memo1.Lines.add('Enums: '+IntToStr(CVSTRACtablepointerenums.Count));
    if CVSTRACtablepointerenums.Count > 0 then
      begin
      //display first row
      while i <= CVSTRACtablepointerenums.Count do
      begin
      stype := CVSTRACtablepointerenums.FieldAsString(CVSTRACtablepointerenums.FieldIndex['type']);
      if (stype = 'type') then
        begin
        sSQL := 'INSERT INTO enum(type,name,value) VALUES ("ticket_type","'+
          CVSTRACtablepointerenums.FieldAsString(CVSTRACtablepointerenums.FieldIndex['name'])
          +'","'+
          CVSTRACtablepointerenums.FieldAsString(CVSTRACtablepointerenums.FieldIndex['idx'])
          +'");';
       //do the insert
        TracdbPointer.BeginTransaction;
        TracdbPointer.ExecSQL(sSQL);
        TracdbPointer.Commit;
        end
      else
      if (stype = 'status') then
        begin
        sSQL := 'INSERT INTO enum(type,name,value) VALUES ("status","'+
          CVSTRACtablepointerenums.FieldAsString(CVSTRACtablepointerenums.FieldIndex['name'])
          +'","'+
          CVSTRACtablepointerenums.FieldAsString(CVSTRACtablepointerenums.FieldIndex['idx'])
          +'");';
       //do the insert
        TracdbPointer.BeginTransaction;
        TracdbPointer.ExecSQL(sSQL);
        TracdbPointer.Commit;
        end
      else
        if stype = 'subsys' then
          begin
        sSQL := 'INSERT INTO component(name,owner,description) VALUES ("'+
          CVSTRACtablepointerenums.FieldAsString(CVSTRACtablepointerenums.FieldIndex['name'])
          +'","conversion","'+
          CleanStr(CVSTRACtablepointerenums.FieldAsString(CVSTRACtablepointerenums.FieldIndex['value']))
          +'");';
       //do the insert
        TracdbPointer.BeginTransaction;
        TracdbPointer.ExecSQL(sSQL);
        TracdbPointer.Commit;
          end;

      Memo1.lines.add(
         CVSTRACtablepointerenums.FieldAsString(CVSTRACtablepointerenums.FieldIndex['type'])+' '+
         CVSTRACtablepointerenums.FieldAsString(CVSTRACtablepointerenums.FieldIndex['idx'])+' '+
         CVSTRACtablepointerenums.FieldAsString(CVSTRACtablepointerenums.FieldIndex['name'])+' '+
         CVSTRACtablepointerenums.FieldAsString(CVSTRACtablepointerenums.FieldIndex['value'])+' '+
         CVSTRACtablepointerenums.FieldAsString(CVSTRACtablepointerenums.FieldIndex['color']));
      CVSTRACtablepointerenums.Next;
      inc(i);
      end;
      end;
    CVSTRACtablepointerenums.free;
//      Notes :=  CVSTRACtablepointerenums.FieldAsBlobText(CVSTRACtablepointerenums.FieldIndex['Notes']);
//      memNotes.Text := notes;

    //query the data
    CVSTRACtablepointerchng := CVSTRACdbpointer.GetTable('SELECT * FROM chng');
    memo1.Lines.Add('chng '+IntToStr(CVSTRACtablepointerchng.Count));
    i := 1;
    if CVSTRACtablepointerchng.Count > 0 then
      begin
      //lookup field Index values
      MilestoneIDX := CVSTRACtablepointerchng.FieldIndex['milestone'];
      MessageIDX := CVSTRACtablepointerchng.FieldIndex['message'];
      NewTextIDX := CVSTRACtablepointerchng.FieldIndex['branch'];
      UserIDX := CVSTRACtablepointerchng.FieldIndex['user'];
      DateIDX := CVSTRACtablepointerchng.FieldIndex['date'];
      while i <= CVSTRACtablepointerchng.Count do
      begin
      ms := CVSTRACtablepointerchng.FieldAsString(MilestoneIDX);
      msg := CVSTRACtablepointerchng.FieldAsString(MessageIDX);
      if ms = '1' then
        ms := 'Release of '
      else
        if ms = '2' then
          ms := 'Milestone '
        else
          ms := '';
      if (ms <> '') and (trim(msg) <> '') and (Milestones.IndexOf(msg) < 0) then
        begin
        MileStones.Add(msg);
        branch := CVSTRACtablepointerchng.FieldAsString(NewTextIDX);
        if trim(branch) <> '' then
          Branch := ' on branch '+Branch;
        sSql := 'INSERT INTO milestone(name,due,completed,description) VALUES ("'+
                msg+
                '",0,'+
                CVSTRACtablepointerchng.FieldAsString(DateIDX)+
                ',"'+
                ms+msg+ ' by '+
                  CVSTRACtablepointerchng.FieldAsString(UserIDX)+
                  branch+
                '");';
        TracdbPointer.BeginTransaction;
        TracdbPointer.ExecSQL(sSQL);
        TracdbPointer.Commit;
        end;
      inc(i);
      CVSTRACtablepointerchng.Next;
      end;
      end;
    CVSTRACtablepointerchng.Free;

    version := TStringList.Create;

    //query the data
    CVSTRACtablepointerticket := CVSTRACdbpointer.GetTable('SELECT * FROM ticket;');
    i := 1;
    Memo1.Lines.add('Tickets '+IntToStr(CVSTRACtablepointerticket.Count));
    earlydate := '';
    if CVSTRACtablepointerticket.Count > 0 then
      begin
      //Get Field Index Values
      TicketNumIDX := CVSTRACtablepointerTicket.FieldIndex['tn'];
      DateIDX := CVSTRACtablepointerTicket.FieldIndex['origtime'];
      StatusIDX := CVSTRACtablepointerTicket.FieldIndex['status'];
      UserIDX := CVSTRACtablepointerTicket.FieldIndex['assignedto'];
      VersionIDX := CVSTRACtablepointerTicket.FieldIndex['version'];
      PriorityIDX := CVSTRACtablepointerTicket.FieldIndex['priority'];
      SeverityIDX := CVSTRACtablepointerTicket.FieldIndex['severity'];
      OldTextIDX := CVSTRACtablepointerTicket.FieldIndex['remarks'];
      TypeIDX := CVSTRACtablepointerTicket.FieldIndex['type'];
      TitleIDX := CVSTRACtablepointerTicket.FieldIndex['title'];
      ChangeTimeIDX := CVSTRACtablepointerTicket.FieldIndex['changetime'];
      SubsystemIDX := CVSTRACtablepointerTicket.FieldIndex['subsystem'];
      OwnerIDX := CVSTRACtablepointerTicket.FieldIndex['owner'];
      ContactIDX := CVSTRACtablepointerTicket.FieldIndex['contact'];
      DescriptionIDX := CVSTRACtablepointerTicket.FieldIndex['description'];
      for p := 1 to 5 do
        extrastr[p].I := CVSTRACtablepointerticket.FieldIndex['extra'+IntToStr(p)];
      while i <= CVSTRACtablepointerticket.Count do
      begin
//INSERT INTO "ticket"
//VALUES(1,'defect',1185851388,1186020982,'component1',NULL,'major','assignedto','anonymous','cc@knurl.com','1.0','milestone1','new',NULL,'this is a test ticket summary line','this is a test ticket description link','keywords');
//CREATE INDEX ticket_time_idx ON ticket (time);
//CREATE INDEX ticket_status_idx ON ticket (status);
//COMMIT;
        tn := CVSTRACtablepointerTicket.FieldAsString(TicketNumIDX);
        dt := CVSTRACtablepointerTicket.FieldAsString(DateIDX);
        status := CVSTRACtablepointerTicket.FieldAsString(StatusIDX);
        user := CVSTRACtablepointerTicket.FieldAsString(UserIDX);
        ver := CVSTRACtablepointerTicket.FieldAsString(VersionIDX);
        prio := CVSTRACtablepointerTicket.FieldAsString(PriorityIDX);
        sevr := CVSTRACtablepointerTicket.FieldAsString(SeverityIDX);
        oldtxt := fixdblq(CVSTRACtablepointerTicket.FieldAsString(OldTextIDX));
        if trim(oldtxt) <> '' then
         oldtxt := #13#10#13#10+'============='+#13#10#13#10+ oldtxt;
        milestone := '';
        resolution := '';
        val(prio,P,e);
        if e <> 0 then p := 1;
        val(sevr,S,e);
        if e <> 0 then s := 1;
        if (dt < Earlydate) or (Earlydate = '') then
          EarlyDate := dt;
        if trim(ver) <> '' then
          if Version.IndexOf(ver) < 0 then
            begin
            Version.Add(ver);
            sSQL := 'INSERT INTO version(name,time,description) VALUES ("'+ver+'",0,"");';
           //do the insert
            TracdbPointer.BeginTransaction;
            TracdbPointer.ExecSQL(sSQL);
            TracdbPointer.Commit;
            end;
        if (status = 'closed') then begin resolution := 'fixed'; end;
{
        CVSTRACtablepointerxref := CVSTRACdbpointer.GetTable('SELECT chng.milestone,chng.message FROM xref,chng WHERE xref.tn = '+tn+' and xref.cn = chng.cn');
        if CVSTRACtablepointerxref.Count > 0 then
          begin
          CVSTRACtablepointerchng := CVSTRACdbpointer.GetTable('SELECT * FROM chng where');
          i := 1;
          if CVSTRACtablepointerchng.Count > 0 then
            begin
            end;
          CVSTRACtablepointerchng.Free;
          end;
        CVSTRACtablepointerxref.Free;
}
        sSQL := 'INSERT INTO ticket('+
                'id,type,time,changetime,component,'+
                'severity,priority,owner,reporter,'+
                'cc,version,milestone,status,resolution,'+
                'summary,description,keywords'+
                ') VALUES ('+
          tn                                                                                           //id
          +',"'+
          CVSTRACtablepointerTicket.FieldAsString(TypeIDX)        //type
          +'",'+
          dt    //time
          +','+
          CVSTRACtablepointerTicket.FieldAsString(ChangeTimeIDX)  //changetime
          +',"'+
          CVSTRACtablepointerTicket.FieldAsString(SubsystemIDX)   //component
          +'","'+
          SeverityStr[p]    //severity (which was Priority in CVSTeac) SeverityStr is Trac and P is CVSTrac
          +'","'+
          PriorityStr[s]    //priority (which was Severity in CVSTrac) PriorityStr is Trac and S is CVSTrac
          +'","'+
          user  //owner
          +'","'+
          CVSTRACtablepointerTicket.FieldAsString(OwnerIDX)       //reporter
          +'","'+
          CVSTRACtablepointerTicket.FieldAsString(ContactIDX)     //cc
          +'","'+
          ver                                                                                          //version
          +'","'+
          milestone                                                                                    //milestone
          +'","'+
          status                                                                                       //status  (new,assignedto,
          +'","'+
          resolution                                                                                   //resolution
          +'","'+
          fixdblq(CVSTRACtablepointerTicket.FieldAsString(TitleIDX)) //summary
          +'","'+
          fixdblq(CVSTRACtablepointerTicket.FieldAsString(DescriptionIDX)) //description
          +oldtxt                                                                                       // remarks if any
          +'","'+
          ''                                                                                           //keywords
          +'");';
       //do the insert
        TracdbPointer.BeginTransaction;
        TracdbPointer.ExecSQL(sSQL);
        for p := 1 to 5 do
         if extrastr[p].S <> '' then
          begin
          newtxt := CVSTRACtablepointerticket.FieldAsString(extrastr[p].I);
          sSQL := 'INSERT INTO ticket_custom(ticket,name,value) VALUES ('+
            tn+',"'+lowercase(extrastr[p].S)+'","'+
            fixdblq(newtxt)
            +'");';
         //do the insert
          TracdbPointer.ExecSQL(sSQL);
          end;
      TracdbPointer.Commit;

      Memo1.lines.add(
         tn+' '+
         CVSTRACtablepointerTicket.FieldAsString(TypeIDX)+' '+
         status+' '+
         User+' '+
         CVSTRACtablepointerTicket.FieldAsString(TitleIDX));
      CVSTRACtablepointerTicket.Next;
      inc(i);
      end;
      end;
    CVSTRACtablepointerticket.free;
    memo1.Lines.add('total versions '+IntToStr(Version.Count));
    version.Free;
    //query the data
    CVSTRACtablepointertktchng := CVSTRACdbpointer.GetTable('SELECT * FROM tktchng;');
    memo1.Lines.Add('tktchng '+IntToStr(CVSTRACtablepointertktchng.Count));
    i := 1;
    if CVSTRACtablepointertktchng.Count > 0 then
      begin
      //display first row
      TicketNumIDX := CVSTRACtablepointertktchng.FieldIndex['tn'];
      UserIDX := CVSTRACtablepointertktchng.FieldIndex['user'];
      DateIDX := CVSTRACtablepointertktchng.FieldIndex['chngtime'];
      TypeIDX := CVSTRACtablepointertktchng.FieldIndex['fieldid'];
      OldTextIDX := CVSTRACtablepointertktchng.FieldIndex['oldval'];
      NewTextIDX := CVSTRACtablepointertktchng.FieldIndex['newval'];
      while i <= CVSTRACtablepointertktchng.Count do
      begin
      tn := CVSTRACtablepointertktchng.FieldAsString(TicketNumIDX);
      user := CVSTRACtablepointertktchng.FieldAsString(UserIDX);
      dt := CVSTRACtablepointertktchng.FieldAsString(DateIDX);
      fldid := fixdblq(CVSTRACtablepointertktchng.FieldAsString(TypeIDX));
      oldtxt := fixdblq(CVSTRACtablepointertktchng.FieldAsString(OldTextIDX));
      newtxt := fixdblq(CVSTRACtablepointertktchng.FieldAsString(NewTextIDX));
      // cant change:  tn(id)
      // stay the same:  type(type),changetime(changetime),version(version)
      //                 status(status),description(description)
      if fldid = 'origtime' then fldid := 'time' else
      if fldid = 'derivedfrom' then fldid := '' else
      if fldid = 'assignedto' then fldid := 'owner' else
      if fldid = 'severity' then fldid := 'priority' else
      if fldid = 'priority' then fldid := 'severity' else
      if fldid = 'subsystem' then fldid := 'component' else
      if fldid = 'owner' then fldid := 'reporter' else
      if fldid = 'title' then fldid := 'summary' else
      if fldid = 'contact' then fldid := 'cc' else
      if fldid = 'extra1' then fldid := extrastr[1].S else
      if fldid = 'extra2' then fldid := extrastr[2].S else
      if fldid = 'extra3' then fldid := extrastr[3].S else
      if fldid = 'extra4' then fldid := extrastr[4].S else
      if fldid = 'extra5' then fldid := extrastr[5].S else
      if fldid = 'remarks' then
        begin
        fldid := 'description';
        dt := IntToStr(StrToInt(dt)+1);
        end;

      if fldid <> '' then
        begin
        Memo1.Lines.add(inttostr(i)+' '+tn+' '+user+' '+fldid);
        sSql := 'INSERT INTO ticket_change(ticket,time,author,field,oldvalue,newvalue) VALUES ('+
                  tn+','+dt+',"'+
                  user+'","'+fldid+'","'+oldtxt+'","'+newtxt+'");';
        TracdbPointer.BeginTransaction;
        TracdbPointer.ExecSQL(sSQL);
        TracdbPointer.Commit;
        end;
      inc(i);
      CVSTRACtablepointertktchng.Next;
      end;
      end;
    CVSTRACtablepointertktchng.Free;



    sSQL := 'UPDATE wiki SET time = '+earlydate;
    TracdbPointer.BeginTransaction;
    TracdbPointer.ExecSQL(sSQL);
    TracdbPointer.Commit;

    //query the data
    CVSTRACtablepointerwiki := CVSTRACdbpointer.GetTable('SELECT * FROM wiki;');
    memo1.Lines.Add('wiki '+IntToStr(CVSTRACtablepointerwiki.Count));
    // CVSTRAC: name & date create a unique identity for an entry
    // TRAC:    name & version create a unique identity for an entry
    version := TStringList.Create;
    TRACtablepointerWiki := TRACdbpointer.GetTable('SELECT name,version FROM wiki;');
    i := 1;
    if TRACTablepointerWiki.Count > 0 then
      begin
      While i <= TRACtablepointerWiki.Count do
        begin
        tn := fixdblq(TRACtablepointerwiki.FieldAsString(TRACtablepointerwiki.FieldIndex['name']));
        dt := '00000'+TRACtablepointerwiki.FieldAsString(TRACtablepointerwiki.FieldIndex['version']);
        dt := copy(dt,length(dt)-4,5);
        if Version.IndexOfName(tn) < 0 then
          begin
          Version.Add(tn+'='+dt);
          end
        else
          begin
          Ver := Version.Values[tn];
          if dt > Ver then
            begin
            p := Version.IndexOfName(tn);
            Version[p] := tn+'='+dt;
            end;
          end;
        TRACtablepointerWiki.Next;
        inc(i);
        end;
      end;
    TRACtablepointerWiki.Free;
    i := 1;
    if CVSTRACtablepointerwiki.Count > 0 then
      begin
      while i <= CVSTRACtablepointerwiki.Count do
        begin
        tn := fixdblq(CVSTRACtablepointerwiki.FieldAsString(CVSTRACtablepointerwiki.FieldIndex['name']));
        dt := trim(CVSTRACtablepointerwiki.FieldAsString(CVSTRACtablepointerwiki.FieldIndex['invtime']));
        if copy(dt,1,1) = '-' then delete(dt,1,1);
        user := CVSTRACtablepointerwiki.FieldAsString(CVSTRACtablepointerwiki.FieldIndex['who']);
        fldid := CVSTRACtablepointerwiki.FieldAsString(CVSTRACtablepointerwiki.FieldIndex['ipaddr']);
        oldtxt := fixdblq(CVSTRACtablepointerwiki.FieldAsString(CVSTRACtablepointerwiki.FieldIndex['text']));
        newtxt := CVSTRACtablepointerwiki.FieldAsString(CVSTRACtablepointerwiki.FieldIndex['locked']);
        if trim(user) <> '' then
          begin
          if Version.IndexOfName(tn) < 0 then
            begin
            Version.Add(tn+'=1');
            ver := '1';
            end
          else
            begin
            p := StrToInt(Version.Values[tn]);
            inc(p);
            Ver := IntToStr(p);
            p := Version.IndexOfName(tn);
            Version[p] := tn+'='+ver;
            end;
          sSql := 'INSERT INTO wiki(name,version,time,author,ipnr,text,comment,readonly) VALUES ("'
                    +tn+'",'+ver+','+dt+',"'+
                    user+'","'+fldid+'","'+oldtxt+'",NULL,'+newtxt+');';
          TracdbPointer.BeginTransaction;
          TracdbPointer.ExecSQL(sSQL);
          TracdbPointer.Commit;
          end;
        inc(i);
        CVSTRACtablepointerwiki.Next;
        end;
      end;
    CVSTRACtablepointerwiki.free;
    version.free;
  finally
  end;

finally
  CVSTRACdbpointer.Free;
  TRACdbpointer.Free;
end;
Memo1.lines.add('Conversion Completed');
end;


procedure TForm1.Button2Click(Sender: TObject);
var
    CVSTRACdbpointerpath: string;
    CVSTRACdbpointer: TSQLiteDatabase;
    CVSTRACtablepointer: TSQLIteTable;

begin

CVSTRACdbpointerpath := ExtractFilepath(application.exename) + 'trac.db';
CVSTRACdbpointer := TSQLiteDatabase.Create(CVSTRACdbpointerpath);

try

  if not CVSTRACdbpointer.TableExists('ticket') then
    begin
    memo1.lines.add('ticket input table not found');
    end;


  //query the data
  CVSTRACtablepointer := CVSTRACdbpointer.GetTable('SELECT * FROM ticket');
  try
        Memo1.Lines.add(IntToStr(CVSTRACtablepointer.columnType[0])+' '+
                        IntToStr(CVSTRACtablepointer.columnType[1])+' '+
                        IntToStr(CVSTRACtablepointer.columnType[2])+' '+
                        IntToStr(CVSTRACtablepointer.columnType[3])+' '+
                        IntToStr(CVSTRACtablepointer.columnType[4]));

  finally
    CVSTRACtablepointer.Free;
  end;

finally
  CVSTRACdbpointer.Free;
end;


end;

procedure TForm1.Button3Click(Sender: TObject);
var
    CVSTRACdbpointerpath: string;
    CVSTRACdbpointer: TSQLiteDatabase;
    CVSTRACtablepointer: TSQLIteTable;
    i : integer;

begin

CVSTRACdbpointerpath := ExtractFilepath(application.exename) + cvstracdbname;
CVSTRACdbpointer := TSQLiteDatabase.Create(CVSTRACdbpointerpath);

try

  if not CVSTRACdbpointer.TableExists('ticket') then
    begin
    memo1.lines.add('ticket input table not found');
    end;


  //query the data
  CVSTRACtablepointer := CVSTRACdbpointer.GetTable('SELECT priority FROM ticket GROUP BY priority');
  try
    i := 1;
    Memo1.Lines.add(IntToStr(CVSTRACtablepointer.Count));
    if CVSTRACtablepointer.Count > 0 then
      begin
      //display first row
      while (i <= CVSTRACtablepointer.Count) and (i < 10) do
      begin
        Memo1.Lines.add(
            CVSTRACtablepointer.FieldAsString(0)
             );
        CVSTRACtablepointer.Next;
        inc(i);
      end;
      end;
  finally
    CVSTRACtablepointer.Free;
  end;

finally
  CVSTRACdbpointer.Free;
end;


end;

procedure TForm1.Button4Click(Sender: TObject);
begin
{
python trac-digest.py -u username -p password
a056fafaf587799d45f19dea506ef6fd
username:trac:a056fafaf587799d45f19dea506ef6fd
}
  memo1.lines.add(uppercase('a056fafaf587799d45f19dea506ef6fd'));
  memo1.lines.add(MD5DigestToStr(MD5String('username:trac:password')));
end;

end.

